﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Get Veteran Identifiers step.
    /// </summary>
    public class GetVeteranIdentifiersStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (state.Veteran == null) return;

            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                state.VeteranIdentifiers = context.mcs_personidentifiersSet.Where(x => x.mcs_patient.Id == state.Veteran.Id).ToList();
                
                if (state.VeteranIdentifiers == null || !state.VeteranIdentifiers.Any())
                {
                    throw new Exception("The Veteran does not have any MVI Identifiers");
                }

                state.VeteranIcn = state.VeteranIdentifiers.FirstOrDefault(x => x.mcs_assigningauthority == "USVHA" && x.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI);
                if (state.VeteranIcn == null) throw new Exception("Veteran does not have an National Identifier");

                state.VeteranSs = state.VeteranIdentifiers.FirstOrDefault(x => x.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.SocialSecurity_SS);
                if (state.VeteranSs == null) throw new Exception("Veteran does not have an SS Identifier");
            }
        }
    }
}